* Program....: REMCOUNT.PRG
* Version....: 1.0
* Author.....: Ted Roche, MCSD
* Date.......: Tuesday July 29, 1997
* Notice.....: Copyright (c) 1997 Ted Roche. All Rights Reserved.
* Compiler...: FoxPro 2.6a for Windows
* Abstract...: count number of remarks, return lines/remarks
* Changes....: tr - 07/29/1997 11:13:38 - modified original
* ...........: prototype to accept parameters
* ...........:  && tr - 07/31/1997 15:51:06 - added tcCode
* ...........: parameter. Optional. If used, ignore file
* ...........: and just count code in the passed tcCode

parameters tcFileName, tnCode, tnComment, tcCode
NOTE: tn parameters must be passed by reference ;
 if they are to return values
      
private lnComments, lnCodeLines, lcLine2Read, lnSelect
private lnMemoWidth, lcSetTalk
private lnTotLines  && tr - 07/29/199712:12:22

if SET("TALK") = "ON"
   set talk off
   lcSetTalk = "ON"
else
   lcSetTalk = "OFF"
endif
lnMemoWidth = SET("MEMOWIDTH")
set MEMOWIDTH TO 255
    
lnComments = 0
lnCodeLines = 0

lnSelect = SELECT() && preserve original work area
select 0  && find an open workarea
create cursor temporary (SourceCode M)

IF TYPE("tcCode") = "C" and NOT EMPTY(tcCode)
   insert into temporary values (tcCode)
ELSE
   IF TYPE("tcFileName") = "C" and FILE(tcFileName)
      lcFileIn = tcFileName
   ELSE
      * lcFileIn = GETFILE("PRG","Select Program to review")
      lcFileIn = ""
      ? "can't find " + tcFilename
   ENDIF
   if file(lcFileIn)
      append blank
      append memo SourceCode from (lcFileIn)
   endif
ENDIF

_mline = 0
lnTotLines = MEMLINES(SourceCode)
for i = 1 to lnTotLines
   lcLine2Read = upper(alltrim(MLINE(SourceCode,1,_MLINE)))
   do case

      case empty(lcLine2Read)  && blank
         * go on, increment neither

      * Lines and boxes from GenScrn/FoxDoc - view source in
      * FoxFont to see them
      case lcLine2Read = "*       " OR ;
           lcLine2Read = "*       " OR ;
           lcLine2Read = "*       " OR ;
           lcLine2Read = "*       " OR ;
           lcLine2Read = "*:" OR ;
           lcLine2Read = "*!" 
        * Auto-generated lines using GenScrn or FoxDoc
        * skip and don't increment either
           
      case lcLine2Read = "*" or ;
         lcLine2Read = "NOTE"  && comment
         lnComments = lnComments + 1

      case "&" + "&" $ lcLine2Read
         lnComments = lnComments + 1
         lnCodeLines = lnCodeLines + 1

      otherwise  && must be a line of code
         lnCodeLines = lnCodeLines + 1

   endcase
   * Skip past all lines which are a continuation
   * of this one
   do while i <= lnTotLines and ;
    right(lcLine2Read,1) = ";"
      i = i + 1
      lcLine2Read = upper(alltrim(MLINE(SourceCode,1,_MLINE)))
   enddo
next

* Determine if parameters were passed in ;
* if so, populate their values and return.
* Otherwise, display the results
IF PCOUNT() >= 3
   tnCode = lnCodeLines
   tnComment = lnComments
ELSE
    wait window ltrim(str(lnCodeLines)) + " lines of Code" + chr(13) + ;
    ltrim(str(lnComments)) + " lines of comments " + chr(13) + ;
    ltrim(str(lnCodeLines/lnComments,5,2)) + " code/* ratio"
ENDIF
use  && close cursor
select (lnSelect)  && restore original work area
set talk &lcSetTalk
set memowidth to lnMemowidth

* Situations:
* Multi-line comment with "*" at beginning of each line
* counts as separate comments
* Comments that have continuation lines ;
 like this one are not counted as comments ;
 but are they commands ? Nah...
* Should count comments or cod eby their first line, and then 
* skip to the end of the continued code
* This is what ap has been made to do now.
