* Widget.PRG 
* Ted Roche, 15 August 2001

LOCAL oReturn as widget
oReturn = CREATEOBJECT("Widget")
RETURN oReturn

define class widget as relation
  PROTECTED Process[5,2]
  PROTECTED ProcessCount
  ProcessCount = 2
  Process[1,1] = "Setup"
  Process[1,2] = 0.14
  Process[2,1] = "Finish"
  Process[2,2] = 0.11
  
PROCEDURE Init()
ENDPROC

PROCEDURE Destroy()
ENDPROC  && Destroy

PROCEDURE Calculate()
  * Calculate the net cost of widget
  * Return negative number for errors:
  * -1 if a cost was not numeric
  * -2 if the ProcessCount > dimensions
  LOCAL nReturn
  nReturn = 0
  
  IF THIS.ProcessCount > ALEN(THIS.Process,1)
    RETURN -2
  ENDIF
  
  LOCAL i, nCost, nStepCost
  nCost = 0
  FOR i = 1 TO THIS.ProcessCount
    nStepCost = THIS.Process[i,2]
    IF VARTYPE(nStepCost) <> "N"
      nReturn = -1  && return an error code
    ELSE
      nCost = nCost + THIS.Process[i,2]
    ENDIF
  ENDFOR  && i = 1 TO this.processcount
  
  RETURN IIF(nReturn = 0, nCost, nReturn)
  
ENDPROC  && Calculate

PROCEDURE testCalculate
  THIS.Setup()

  LOCAL lcResult
  lcResult = "OK"
  * Test 1: Normal result should be .25
  IF THIS.Calculate() = .25
    lcResult = "OK Test 1 "
  ENDIF
  
  * Test 2: failure when Process Count too high
  THIS.ProcessCount = 50
  IF THIS.Calculate() = -2
    lcResult = lcResult + "OK Test 2 "
  ELSE
    lcResult = lcResult + "FAIL Test 2"
  ENDIF
  THIS.ProcessCount = 2
  
  * Test 2: failure when ProcessCost not numeric
  THIS.ProcessCount = 3  && third value not set
  IF THIS.Calculate() = -1
    lcResult = lcResult + "OK Test 3 "
  ELSE
    lcResult = lcResult + "FAIL Test 3"
  ENDIF
  
  THIS.ProcessCount = 2

  * End tests, restore environment
  THIS.TearDown()
  
  RETURN lcResult
ENDPROC && testCalculate

PROCEDURE Setup()
  * set the stage for testing here
  THIS.ProcessCount = 2
  DIMENSION THIS.Process[5,2]
  THIS.Process[1,1] = "Setup"
  THIS.Process[1,2] = 0.14
  THIS.Process[2,1] = "Finish"
  THIS.Process[2,2] = 0.11
ENDPROC  && Setup

PROCEDURE TearDown()
  * restore default values here
  THIS.ProcessCount = 2
  DIMENSION THIS.Process[5,2]
  THIS.Process[1,1] = "Setup"
  THIS.Process[1,2] = 0.14
  THIS.Process[2,1] = "Finish"
  THIS.Process[2,2] = 0.11
ENDPROC && TearDown()

enddefine
