*==============================================================================
* Program:				MAKEFOXWIKIRSS.PRG
* Purpose:				Generate a FoxWiki RSS file
* Author:				Ted Roche
* Copyright:			(c) 2003
* Last revision:		Thursday, 27 February, 2003
* Parameters:
* Returns:
* Environment in:
* Environment out:
*==============================================================================
LOCAL lcXML AS STRING, ;
  lcFileName AS STRING, ;
  lcContents AS STRING, ;
  lcWebPage AS STRING, ;
  lcText AS STRING, ;
  lcSafety as String 

IF VERSION(2) = 0 && runtime
  SYS(2335,0) && set unattended server mode
ENDIF && runtime

* SUSPEND
try

CLOSE DATABASES ALL

* First, retrieve the most recent changes from the site
* The ~1 specifies one day of information.
lcWebPage = ReadURL("http://fox.wikis.com/wc.dll?Wiki~RecentChanges~1~&mode=xml")
* For testing, to minimize load:
* lcWebPage = FILETOSTR("Recent.xml")

IF EMPTY(lcWebPage)  && RECCOUNT("Hurl") = 0
  ERROR "Failed to read the URL"
  RETURN .F.
ENDIF

* Convert to a "Topics" cursor
XMLTOCURSOR('<?xml version="1.0"?>'+CHR(13)+STREXTRACT(lcWebPage,"<wiki>","</wiki>"), "Topics")

* Bug fix - 19-Aug-2003 (Induction day, 24 years ago)
* Sometimes, there are no new topics, so we get an "Alias 'Topics' does not exist" below
IF NOT USED("Topics")
  * No new topics, bail
  RETURN
ENDIF

* Create an output file with header, named FoxWikiYYYYMMDDHHMMSS.txt
* lcFileName = "FoxWiki" + TTOC(DATETIME(),1)+".txt" - debugging
lcFileName = "FoxWikiRSS20.xml"
* lcContents = TEXTMERGE(FILETOSTR("foxwiki.xml"))  && -- see textmerging below


* Create/update a table of the topics and brief description of each
IF NOT FILE("FoxWiki.dbf")
  SELECT 0
  CREATE TABLE FoxWiki (cTitle c(128), mDesc M, cLink c(128), tUpdated T)
  INDEX ON cTitle TAG cTitle
ELSE  && exists, open it
  SELECT 0
  USE FoxWiki
ENDIF

SELECT topics
SCAN

  * Determine if the topic has already been scanned

  IF SEEK(topics.NAME,"FoxWiki","ctitle")
    * \\ this leave the text alone, assuming (!) the change is added
    * to the end of the topic, or otherwise doesn't affect topic.
    UPDATE FoxWiki SET tUpdated=Topics.Updated WHERE FoxWiki.cTitle=Topics.Name
    * already found, skip it
  ELSE
    lcWebPage = ReadURL(topics.xmllink)
    lcText = HTMLText(STREXTRACT(lcWebPage,"<text>","</text>"))
    INSERT INTO FoxWiki VALUES (topics.NAME, lcText, topics.LINK, topics.Updated)
  ENDIF

ENDSCAN

* Convert field names with a Select
* SELECT name as Title, name as description, link FROM ("Topics") INTO CURSOR Item
SELECT topics.NAME AS TITLE, ;
  FoxWiki.mDesc AS DESCRIPTION, ;
  topics.LINK AS LINK, ;
  topics.Link as guid, ;
  XMLDateTime(updated) as pubDate;
  FROM topics INNER JOIN FoxWiki ON topics.NAME = FoxWiki.cTITLE ;
  INTO CURSOR ITEM

* changed to produce one record, for testing
* CURSORTOXML("Item", "lcXML", 1,0,1,"")
CURSORTOXML("Item", "lcXML",1,0+8,0,"")

* Strip the extra header
*!*	  <?xml version = "1.0" encoding="Windows-1252" standalone="yes"?>
*!*	<VFPData>
* lcXML = SUBSTR(lcXML, AT(CHR(13),lcXML,2)+1)
* strip the footer as well
* lcXML=STRTRAN(lcXML,"</VFPData>")

lcXML = STREXTRACT(lcXML, "<VFPData>", "</VFPData>")

* Camel-case pubDate
lcXML = STRTRAN(lcXML ,"pubdate>","pubDate>")


SET TEXTMERGE TO memvar lcContents
SET TEXTMERGE ON noshow
\<?xml version="1.0" ?> 
\<!--  RSS generated by <<VERSION()>> on <<XMLDateTime(DATETIME())>>--> 
\<rss version="2.0">
\<channel>
\  <title>FoxForum Wiki</title> 
\  <link>http://fox.wikis.com/</link> 
\  <description>KnowledgeBase and Community about Visual FoxPro</description> 
\  <language>en-us</language> 
\  <copyright>Copyright 2002 by the authors</copyright> 
\  <lastBuildDate><<XMLDateTime(DATETIME())>></lastBuildDate> 
\  <docs>http://backend.userland.com/rss</docs> 
\  <generator><<VERSION()>></generator> 
\  <category domain="Syndic8">23766</category> 
\  <ttl>40</ttl> 
\  
\  <<lcXML>>
\  
\</channel>
\</rss>
SET TEXTMERGE to
SET TEXTMERGE off


* Write it out
lcSafety = SET("Safety")
SET SAFETY OFF
STRTOFILE(lcContents, lcFileName, 0)
SET SAFETY &lcSafety

* display output file
* MODIFY FILE (lcFileName) NOWAIT


CATCH
  lcErrorMessage = TRANSFORM(DATETIME())  + CHR(13) +CHR(10) + ;
                   TRANSFORM(ERROR()) + SPACE(1) + CHR(13) +CHR(10) + ;
                   MESSAGE() + " - " + MESSAGE(1) + CHR(13) + CHR(10)
  STRTOFILE(lcErrorMessage, "FoxWiki.ERR",1)
  AERROR(laError)
  LIST MEMORY LIKE laError TO FILE FoxWiki.err ADDITIVE NOCONSOLE 
  
FINALLY
ENDTRY
