**********************************************************************
* Program....: FOXWIKIWS.PRG
* Version....:
* Author.....: Ted Roche
* Date.......: 04 September 2003, 12:57:35
* Notice.....: Copyright  2003, All Rights Reserved.
* Compiler...: Visual FoxPro 08.00.0000.2521 for Windows
* Abstract...:
* Changes....:
* Parameters.:
* Purpose....: Read the FoxPro Wiki and generate a cursor
**********************************************************************

LOCAL lcXML AS STRING, ;
  lcFileName AS STRING, ;
  lcContents AS STRING, ;
  lcWebPage AS STRING, ;
  lcText AS STRING, ;
  lcSafety as String 

IF VERSION(2) = 0 && runtime
  SYS(2335,0) && set unattended server mode
ENDIF && runtime

CLOSE DATABASES ALL

TRY 

*************************
* Create output cursors *
*************************

CREATE CURSOR curHeader (cTitle c(40), cLink c(254), mDesc M)
INSERT INTO curHeader (cTitle, cLink, mDesc) VALUES ;
                      ("The FoxForum Wiki", ;
                       "http://fox.wikis.com", ;
                       "The online community for interactive and persistant FoxPro knowledge." ;
                       )
*** TEST ITEMS ***
CREATE CURSOR curItem (title c(40), description M, link c(254), updated T)

*******************************************************
*** Read the Recent Changes in XML via Web Services ***
*******************************************************

LOCAL lowikiwebservice AS "XML Web Service"
* LOCAL lowikiwebservice AS "MSSOAP.SoapClient30"
* Do not remove or alter following line. It is used to support IntelliSense for your XML Web service.
*__VFPWSDef__: lowikiwebservice = http://fox.wikis.com/wikiwebservice.wsdl , wikiwebservice , wikiwebserviceSoapPort
LOCAL loException, lcErrorMsg, loWSHandler
loWSHandler = NEWOBJECT("WSHandler",IIF(VERSION(2)=0,"",HOME()+"FFC\")+"_ws3client.vcx")
lowikiwebservice = loWSHandler.SetupClient("http://fox.wikis.com/wikiwebservice.wsdl", "wikiwebservice", "wikiwebserviceSoapPort")

lcWebPage = lowikiwebservice.GetRecentChanges(1,"")

IF EMPTY(lcWebPage)  && RECCOUNT("Hurl") = 0
  ERROR "Failed to read the URL"
  RETURN .F.
ENDIF

* Convert to a "Topics" cursor
XMLTOCURSOR(lcWebPage, "Topics")

* Scan the topics, and read the matching pages
SELECT topics
SCAN

   	lcWebPage = lowikiwebservice.GetTopicText(topics.name)

    lcText = HTML2Text(STREXTRACT(lcWebPage,"<topictext><![CDATA[","]]></topictext>"))
 
    INSERT INTO curItem VALUES(Topics.Name, lcText, Topics.Link, Topics.Updated)
    
ENDSCAN



CATCH
  lcErrorLog = JUSTSTEM(PROGRAM())+".ERR"
  lcErrorMessage = TRANSFORM(DATETIME())  + CHR(13) +CHR(10) + ;
                   TRANSFORM(ERROR()) + SPACE(1) + CHR(13) +CHR(10) + ;
                   MESSAGE() + " - " + MESSAGE(1) + CHR(13) + CHR(10)
  STRTOFILE(lcErrorMessage, lcErrorLog,1)
  AERROR(laError)
  LIST MEMORY LIKE laError TO FILE (lcErrorLog) ADDITIVE NOCONSOLE 
  IF VERSION(2) = 1  && development
    MESSAGEBOX(lcErrorMessage)
  ENDIF
    
FINALLY
ENDTRY

RETURN

FUNCTION HTML2Text
* Removes tags and their contents

LPARAMETERS lcString as String

LOCAL lcTag as String
* Debugging
* use the junk.txt file
* lcString = STREXTRACT(FILETOSTR("junk.txt"),"<text>","</text>")

DO WHILE OCCURS("<", lcString)>0 AND OCCURS(">", lcString)>0
  lcTag = "<" + STREXTRACT(lcString, "<", ">") + ">"
  lcString = STRTRAN(lcString, lcTag)
ENDDO


RETURN lcString