*************************************************
* Program....: ISO8601DATETIME.PRG
* Version....: 1.1
* Author.....: Ted Roche
* Date.......: 19 August 2003, 21:25:13
* Notice.....: Copyright  2003, All Rights Reserved.
* Compiler...: Visual FoxPro 08.00.0000.2521 for Windows
* Abstract...: Returns 2003-02-27T14:11:12Z for 
* ...........: "Thu, 27 Feb 2003 14:11:12 GMT"
* Parameters.: a date/time
* Completely revised code, courtesy of 
* Andrew Coates, posted
* http://fox.wikis.com/wc.dll?Wiki~XMLDateTime

LPARAMETERS tDateTime as Datetime

LOCAL lcReturn as String, lcTZStruct as String, ;
   lnSuntime as Integer, lnUTCOffset as Integer, ;
   lnDaylightBias as Integer

* get the UTC offset -- No need to fake the TZ
DECLARE integer GetTimeZoneInformation IN Win32API ;
   STRING @ TimeZoneStruct
   
lcTZStruct = SPACE(256)
lnSunTime = GetTimeZoneInformation(@lcTZStruct )
lnUTCOffset = WordToInt(SUBSTR(lcTZStruct ,1,4), .t.)
lnDaylightBias = WordToInt(RIGHT(ALLTRIM(lcTZStruct), 4), .t.)

* Add the bias if daylight savings is active
IF lnSunTime = 2
   lnUTCOffset = lnUTCOffset + lnDaylightBias
ENDIF

* convert the offset to seconds
lnUTCOffset = lnUTCOffset * 60

ltUTCTime = tDateTime + lnUTCOffset

lcReturn = TRANSFORM(TTOC(ltUTCTime,1), ;
	"@R 9999-99-99T99:99:99Z")
 
RETURN lcReturn

************************************************************************

FUNCTION WordToInt(tcWordString, tlSigned)

LOCAL lcHexString as String, lnResult as Integer, lnChar as Integer
lcHexString = '0x'

FOR lnChar = LEN(tcWordString) TO 1 STEP -1
  lcHexString = lcHexString + PADL(right(TRANSFORM(ASC(SUBSTR(tcWordString, lnChar, 1)), '@0'), 2), 2, '0')
ENDFOR

lnResult = EVALUATE(lcHexString)
IF tlSigned and lnResult > 0x80000000
  lnResult = lnResult - 1 - 0xFFFFFFFF
ENDIF


RETURN lnResult

ENDFUNC