**********************************************************************
* Program....: RFC822DATE.PRG
* Version....:
* Author.....: Ted Roche
* Date.......: 25 January 2004, 15:15:35
* Notice.....: Copyright  2004 by Ted Roche, under the 
* ...........: Creative Commons Attribution - ShareAlike 1.0 license
* ...........: http://creativecommons.org/licenses/by-sa/1.0/
* Compiler...: Visual FoxPro 08.00.0000.3117 for Windows
* Abstract...:
* Changes....:
* Parameters.:
* Purpose....: Return a datetime IAW http://www.faqs.org/rfcs/rfc822.html
**********************************************************************

* Completely revised code, courtesty of 
* Andrew Coates, posted
* http://fox.wikis.com/wc.dll?Wiki~XMLDateTime

* FUNCTION csXMLDateTime(tDateTime as Datetime) as String
LPARAMETERS tDateTime as Datetime

* Returns "Thu, 27 Feb 2003 14:11:12 GMT"

* get the UTC offset -- No need to fake the TZ
DECLARE integer GetTimeZoneInformation IN Win32API ;
   STRING @ TimeZoneStruct
   
lcTZStruct = SPACE(256)

lnSunTime = GetTimeZoneInformation(@lcTZStruct )

lnUTCOffset = WordToInt(SUBSTR(lcTZStruct ,1,4), .t.)
lnDaylightBias = WordToInt(RIGHT(ALLTRIM(lcTZStruct), 4), .t.)

* Add the bias if daylight savings is active
IF lnSunTime = 2
   lnUTCOffset = lnUTCOffset + lnDaylightBias
ENDIF

* convert the offset to seconds
lnUTCOffset = lnUTCOffset * 60

ltUTCTime = tDateTime + lnUTCOffset

LOCAL lcReturn as String

lcReturn = LEFT(PROPER(CDOW(ltUTCTime)),3) +", "
lcReturn = lcReturn + PADL(DAY(ltUTCTime),2,'0') + SPACE(1)
lcReturn = lcReturn + LEFT(PROPER(CMONTH(ltUTCTime)),3) + SPACE(1)
lcReturn = lcReturn + STR(YEAR(ltUTCTime),4)+SPACE(1)
lcReturn = lcReturn + STUFF(STUFF(RIGHT(TTOC(ltUTCTime,1), 6), 5, 0, ":"), 3, 0, ":") + SPACE(1)
lcReturn = lcReturn + "GMT"
  
RETURN lcReturn

endfunc


************************************************************************

FUNCTION WordToInt(tcWordString, tlSigned)

LOCAL lcHexString as String, lnResult as Integer, lnChar as Integer
lcHexString = '0x'

FOR lnChar = LEN(tcWordString) TO 1 STEP -1
  lcHexString = lcHexString + PADL(right(TRANSFORM(ASC(SUBSTR(tcWordString, lnChar, 1)), '@0'), 2), 2, '0')
ENDFOR

lnResult = EVALUATE(lcHexString)
IF tlSigned and lnResult > 0x80000000
  lnResult = lnResult - 1 - 0xFFFFFFFF
ENDIF


RETURN lnResult

ENDFUNC