**********************************************************************
* Program....: RSS20FOX.PRG
* Version....: 1.0
* Author.....: Ted Roche
* Date.......: 01 February 2004, 10:09:42
* Notice.....: Copyright  2004 by Ted Roche, under the
* ...........: Creative Commons Attribution - ShareAlike 1.0 license
* ...........: http://creativecommons.org/licenses/by-sa/1.0/
* Compiler...: Visual FoxPro 08.00.0000.3117 for Windows
* Abstract...: Generates RSS 2.0 from trhead.dbf and trweb.dbf
* Purpose....: Generate RSS 2.0 in FoxPro without the use of MSXML
* ...........: or CursorToXML(_)
**********************************************************************

LOCAL lcXML as String, lcContents as String, lcFileName
STORE SPACE(0) TO lcXML, lcContents
#DEFINE CRLF CHR(13)+CHR(10)
lcFileName = "trweb.xml"

* Read header information
SELECT cTitle as Title, ;
	cLink as Link, ;
	mDesc as Description ;
FROM trhead ;
INTO CURSOR curHead

* Read news items
Select TOP 10 cTitle as Title, ;
	tUpdated as pubDate, ;
	mContent as Description, ;
	cLink as link ;
FROM trweb ;
ORDER BY tUpdated descending ;
INTO CURSOR curItem

* Generate the items - body'
SELECT curItem
	SET textmerge TO memvar lcXML additive
	SET TEXTMERGE ON noshow
SCAN
	\<item>
	\<title><<HTMLFix(curItem.title)>></title>
	\<description><<HTMLFix(curItem.Description)>></description>
	\<pubDate><<RFC822Date(DATETIME())>></pubDate>
	\<link><<HTMLFix(curItem.Link)>></link>
	\</item>
ENDSCAN
	SET TEXTMERGE off
SET TEXTMERGE to

* Generate the heading and channel items and embed the body within
Set Textmerge To Memvar lcContents
Set Textmerge On Noshow
	\<?xml version="1.0" ?>
	\<!--  RSS generated by <<VERSION()>> -->
	\<rss version="2.0">
	\<channel>
	\  <title><<HTMLFix(curHead.Title)>></title>
	\  <link><<HTMLFix(curHead.Link)>></link>
	\  <description><<HTMLFix(curHead.Description)>></description>
	\  <language>en-us</language>
	\  <copyright>Copyright <<YEAR(DATE())>></copyright>
	\  <lastBuildDate><<RFC822Date(DATETIME())>></lastBuildDate>
	\  <docs>http://blogs.law.harvard.edu/tech/rss</docs>
	\  <generator><<VERSION()>></generator>
	\  <ttl>60</ttl>
	\
	\  <<lcXML>>
	\
	\</channel>
	\</rss>
Set Textmerge To
Set Textmerge Off


* Write it out
lcSafety = Set("Safety")
Set Safety Off
Strtofile(lcContents, lcFileName, 0)
Set Safety &lcSafety

FUNCTION HTMLFix(tcString)
* This code ASSUMES the incoming string is ANSI, CHR(32) to (127)
* and has not already had the characters converted - it will make 
* a mess of string that already has strings line &#151; in it.
LOCAL lcString as string
lcString = STRTRAN(tcString,"&","&amp;")
lcString = STRTRAN(lcString,"<","&lt;")
lcString = STRTRAN(lcString,">","&gt;")
RETURN ALLTRIM(lcString)
